import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:lottie/lottie.dart';

import 'package:admin_desktop/infrastructure/services/utils.dart';

import '../../../../../app_assets.dart';

class NotFound extends StatelessWidget {
  const NotFound({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Lottie.asset(Assets.lottieNotFound, height: 200.h),
        Text(
          AppHelpers.getTranslation(TrKeys.notFound),
          style: Style.interMedium(size: 18, color: Style.black),
        ),
      ],
    );
  }
}
